****《增值税分成激励与地方产业发展》复现代码脚本
****作者：谢立成 张明媛*
****署名单位：上海财经大学财税投资学院
****发表期刊：《经济评论》2026年第1期
****引用格式：谢立成，张明媛. 增值税分成激励与地方产业发展 [J]. 经济评论, 2026(01): 132-145.
****谢立成、张明媛，2026：《增值税分成激励与地方产业发展》，《经济评论》第1期，第132-145页。

**主要变量生成过程
/*
gen secondary= 第二产业增加值/GDP
gen tertiary=第三产业增加值/GDP
gen lnpgdp=ln(人均地区生产总值元)
gen lnpgdp2=(lnpgdp)^2
gen trade=( 货物出口额万元+货物进口额万元)/ GDP
gen asset=固定资产投资总额万元/GDP
gen sale= 社会消费品总额万元/ GDP
gen finance= 年末金融机构各项贷款余额万元 / GDP
gen urbanization= 城镇化水平
g density=ln(人口密度)
g self_sufficiency=一般公共预算收入万元/一般公共预算支出万元
label var self_sufficiency 财政自给率
gen gdp_grow=GDP增速/100
gen marketing=樊纲市场化指数
gen dd=xtreat*post  //生成核心交互项，其中xtreat即为文中的incentive变量
winsor2 secondary tertiary gdp_grow lnpgdp lnpgdp2 trade asset sale finance urbanization density self_sufficiency marketing,cuts(1 99) replace
*/

use "baseline.dta",clear
xtset city_id year
**描述性统计结果输出
su secondary tertiary dd xtreat lnpgdp lnpgdp2 trade asset sale finance urbanization density self_sufficiency marketing gdp_grow 
global cv "gdp_grow lnpgdp lnpgdp2 trade asset sale finance urbanization density self_sufficiency marketing" //设定控制变量
eststo clear
eststo:reghdfe secondary dd $cv ,a(year city_id province_id#i.year) vce(cluster city_id)  //显著为正
eststo:reghdfe tertiary dd $cv ,a(year city_id province_id#i.year ) vce(cluster city_id)  //显著为负
esttab, replace r2(3) b(%6.3f) se(%6.3f) nogaps compress star(* 0.1 ** 0.05 *** 0.01) scalar(N r2) order(dd $cv _cons) noomitted depvar 
 
**分行业的增加值回归
preserve
use "地级市行业增加值合并.dta",clear
merge m:1 city_id year using "baseline.dta",nogen keep(1 3)
**构造必要的变量
 gen 地级市行业增加值_1=地级市行业增加值/1000000 //为避免基准回归系数较大，将行业增加值进行单位转化
global cv "gdp_grow lnpgdp lnpgdp2 trade asset sale finance urbanization density self_sufficiency marketing"
eststo clear
bys 行业分类代码:eststo:qui:reghdfe 地级市行业增加值_1 dd $cv ,a(year city_id province_id#i.year) vce(cluster city_id) 
 esttab, replace r2(3) b(%6.3f) se(%6.3f) nogaps compress star(* 0.1 ** 0.05 *** 0.01) scalar(N r2)  keep(dd $cv _cons) noomitted depvar mtitle("制造业" "建筑业" "批发和零售业" "交通运输业、仓储和邮政业、仓储和邮政业" "住宿和餐饮业" "金融业")
 restore
 
 ***平行趋势图 
use "baseline.dta",clear
gen  period=2016
gen policy=year-period
tab policy,m

forvalues i=5(-1)1{
gen pre`i'=(policy==-`i')
}
gen current=(policy==0 )

forvalues i=1(1)5{
gen post`i'=(policy==`i' )
}
replace current= xtreat  if current==1
replace post1 = xtreat  if post1 ==1
replace post2 = xtreat  if post2 ==1
replace post3 = xtreat  if post3 ==1
replace post4 = xtreat  if post4 ==1
replace post5 = xtreat  if post5 ==1
replace pre1 = xtreat  if pre1 ==1
replace pre2 = xtreat  if pre2 ==1
replace pre3 = xtreat  if pre3 ==1
replace pre4 = xtreat  if pre4 ==1
replace pre5 = xtreat  if pre5 ==1

**先回归第二产业增加值占比，以0期为基期
reghdfe secondary pre5 pre4 pre3 pre2 pre1 post1 post2 post3 post4 post5 $cv ,a(city_id year province_id#i.year) vce(cluster city_id) 
**因变量替换为第三产业占比
//reghdfe tertiary pre5 pre4 pre3 pre2 pre1 post1 post2 post3 post4 post5 $cv ,a(city_id year province_id#i.year) vce(cluster city_id) 	

generate t = invttail(256,0.025)

forvalue i=5(-1)1{
g b_`i' = _b[pre`i']
g se_b_`i' = _se[pre`i']
g b_`i'LB = b_`i' - t*se_b_`i'
g b_`i'UB = b_`i' + t*se_b_`i'
}
forvalue i=1/5{
g b`i' = _b[post`i']
g se_b`i' = _se[post`i']
g b`i'LB = b`i' - t*se_b`i'
g b`i'UB = b`i' + t*se_b`i'
}
generate b = .
generate LB = .
generate UB = .

forvalue i=5(-1)1{
replace b = b_`i'  if policy == -`i'
replace LB = b_`i'LB if policy== -`i'
replace UB = b_`i'UB if policy == -`i'
}
forvalue i=1/5{
replace b = b`i' if policy == `i'
replace LB = b`i'LB if policy== `i'
replace UB = b`i'UB if policy ==`i'
}
generate x=(b_1+b_2+b_3)/4
replace b=b-x
replace LB=LB-x
replace UB=UB-x

keep policy b LB UB
duplicates drop
replace b=0 if policy==0
replace LB=0 if policy==0
replace UB=0 if policy==0
sort policy

twoway (connected b policy, sort lcolor(navy) mcolor(navy) msymbol(circle_hollow) cmissing(n))(rcap LB UB policy, lcolor(navy)    ///
lpattern(dash) msize(medium)),yline(0, lwidth(vthin) lpattern(dash) lcolor(teal))  ///
 ylabel(, labsize(small) angle(horizontal) nogrid) xtitle("政策相对执行时间")  ytitle("差异系数") xtitle(, size(small)) xline(0, lwidth(vthin) lpattern(dash) lcolor(teal)) xlabel(-5(1)5, labsize(small))  ///
 legend(label(1 "估计系数")  label(2 "置信区间") position(6) row(1))  ///
 graphregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white))

********************************稳健性检验**********************************
**稳健型检验部分的回归结果均在附录中
 **********************************1.遗漏变量的稳健性检验图***********************
//参考 Cinelli et al.（2020）提供的针对遗漏变量的敏感性分析方法，以地级市的城镇化率为对比变量，检验潜在的遗漏变量相较于城镇化率需要达到多大强度才会使得之前结果发生变化
use "baseline.dta",clear
global cv "gdp_grow lnpgdp lnpgdp2 trade asset sale finance urbanization density self_sufficiency marketing"
sensemakr secondary dd $cv i.city_id i.year province_id#i.year,treat(dd) benchmark(urbanization) contourplot //遗漏变量敏感性检验（对比城镇化率）——系数β等值线图
sensemakr tertiary dd $cv i.city_id i.year province_id#i.year,treat(dd) benchmark(urbanization) contourplot  //遗漏变量敏感性检验（对比城镇化率）——系数β等值线图

******************************2.安慰剂检验*****************************************
use "baseline.dta",clear
global x "gdp_grow lnpgdp lnpgdp2 trade asset sale finance urbanization density self_sufficiency marketing"
cap erase "D:\A论文科研集\i 税收分成与地方产业结构\回归表格\安慰剂检验\panel1919.dta" //需要先建立好安慰剂检验文件夹
permute dd beta = _b[dd] se = _se[dd] df = e(df_r),reps(500) seed(123) ///
saving("D:\A论文科研集\i 税收分成与地方产业结构\回归表格\安慰剂检验\panel1919.dta"):reghdfe secondary dd  $x, absorb(year city_id province_id#i.year) vce(robust)
permute dd beta = _b[dd],reps(500) seed(123)  ///
saving("D:\A论文科研集\i 税收分成与地方产业结构\回归表格\安慰剂检验\simulations1.dta"):reghdfe secondary dd  $x, absorb(year city_id province_id#i.year) vce(robust)
use "D:\A论文科研集\i 税收分成与地方产业结构\回归表格\安慰剂检验\panel1919.dta",clear
gen t_value = beta / se
gen p_value = 2 * ttail(df,abs(beta/se))
dpplot beta, xline(0.281, lc(black*0.3) lp(dash)) ///
             xline(0, lc(black*0.3) lp(solid)) ///
              xtitle("估计系数", size(*0.8)) ///
             xlabel(, nogrid format(%4.2f) labsize(small)) ///
             ytitle("概率密度", size(*0.8)) ///
			 yline(0.1,lc(black) lp(shortdash)) ///
             ylabel(, nogrid format(%4.2f) labsize(small)) ///
             note("") caption("")   ///
             graphregion(fcolor(white)) 
			
graph set window fontface "Times New Roman" 
graph set window fontfacesans "宋体"

use "baseline.dta",clear
global x  "gdp_grow lnpgdp lnpgdp2 trade asset sale finance urbanization density self_sufficiency marketing"
cap erase "D:\A论文科研集\i 税收分成与地方产业结构\回归表格\安慰剂检验\panel1920.dta"
permute dd beta = _b[dd] se = _se[dd] df = e(df_r),reps(500) seed(123) ///
saving("D:\A论文科研集\i 税收分成与地方产业结构\回归表格\安慰剂检验\panel1920.dta"):reghdfe tertiary dd  $x, absorb(year city_id province_id#i.year) vce(robust)
permute dd beta = _b[dd],reps(500) seed(123)  ///
saving("D:\A论文科研集\i 税收分成与地方产业结构\回归表格\安慰剂检验\simulations2.dta"):reghdfe tertiary dd  $x, absorb(year city_id province_id#i.year) vce(robust)
use "D:\A论文科研集\i 税收分成与地方产业结构\回归表格\安慰剂检验\panel1920.dta",clear
gen t_value = beta / se
gen p_value = 2 * ttail(df,abs(beta/se))
dpplot beta, xline( -0.387, lc(black*0.3) lp(dash)) ///
             xline(0, lc(black*0.3) lp(solid)) ///
              xtitle("估计系数", size(*0.8)) ///
             xlabel(,nogrid format(%4.2f) labsize(small)) ///
             ytitle("概率密度", size(*0.8)) ///
			 yline(0.1,lc(black) lp(shortdash)) ///
             ylabel(, nogrid format(%4.2f) labsize(small)) ///
             note("") caption("")   ///
             graphregion(fcolor(white)) 
graph set window fontface "Times New Roman" 
graph set window fontfacesans "宋体"



**************************3.稳健性检验：PSM-DID**********************************
****************************最邻近匹配法*******************************************
use "baseline.dta",clear
global cv  "gdp_grow lnpgdp lnpgdp2 trade asset sale finance urbanization density self_sufficiency marketing"
su xtreat,detail
gen treat1=1
replace treat1=0  if xtreat<0.1766631 //小于均值
**PSM的部分
set seed 10101 
gen tmp = runiform() 
sort tmp 
psmatch2 treat1 $cv, logit ate neighbor(1) common caliper(0.1) ties 

psmatch2 treat1 $cv, outcome(secondary) logit ate neighbor(1) common caliper(0.1) ties   
pstest $cv,both graph 

gen common=_support
drop if common ==0 

eststo clear
eststo:reghdfe secondary dd  $cv ,a(year city_id province_id#i.year) vce(cluster city_id)
********************************************************************************
use "baseline.dta",clear
global cv  "gdp_grow lnpgdp lnpgdp2 trade asset sale finance urbanization density self_sufficiency marketing"
su xtreat,detail
gen treat1=1
replace treat1=0  if xtreat<0.1766631 //小于均值
**PSM的部分
set seed 10101 
gen tmp = runiform() 
sort tmp 
psmatch2 treat1 $cv, logit ate neighbor(1) common caliper(0.1) ties 
psmatch2 treat1 $cv, outcome(secondary) logit ate neighbor(1) common caliper(0.1) ties   
pstest $cv,both graph 
gen common=_support
drop if common ==0 
eststo:reghdfe tertiary dd $cv, a(year city_id province_id#i.year) vce(cluster city_id)

****************************核匹配法*******************************************
use "baseline.dta",clear
global cv  "gdp_grow lnpgdp lnpgdp2 trade asset sale finance urbanization density self_sufficiency marketing"
su xtreat,detail
gen treat1=1
replace treat1=0  if xtreat<0.1766631 //小于均值
**PSM的部分
set seed 10101 
gen tmp = runiform() 
sort tmp  
psmatch2 treat1 $cv, kernel k(uniform) bw(0.1) common
pstest $cv, both graph  
gen common=_support
drop if common ==0 

eststo:reghdfe secondary dd $cv, a(year city_id province_id#i.year) vce(cluster city_id)

use "baseline.dta",clear
global cv "gdp_grow lnpgdp lnpgdp2 trade asset sale finance urbanization density self_sufficiency marketing"
su xtreat,detail
gen treat1=1
replace treat1=0  if xtreat<0.1766631 //小于均值
**PSM的部分
set seed 10101 
gen tmp = runiform() 
sort tmp 
psmatch2 treat1 $cv, kernel k( uniform) bw(0.1) common  
pstest $cv, both graph  
gen common=_support
drop if common ==0 
eststo:reghdfe tertiary dd $cv,a(year city_id province_id#i.year) vce(cluster city_id)
******PSM结果统一输出
esttab, replace r2(3) b(%6.3f) se(%6.3f) nogaps compress star(* 0.1 ** 0.05 *** 0.01) scalar(N r2)  keep(dd _cons) noomitted depvar indicate( "控制变量=*sale" "city_fe=*lnpgdp" "year_fe=*asset" "province_year_fe=*trade") 
**indicate()括号中的内容仅仅是为了方便表格输出时直接呈现固定效应的标记，减少表格的人工干预程度。其中的固定效应确实已经加在回归过程中，不存在虚构固定效应。后续输出同。

**************************4.其他稳健性检验：排除政策干扰***********************
********************************************************************************
*****排除税收征管一体化/金税工程的影响
use "baseline.dta",clear
global cv "gdp_grow lnpgdp lnpgdp2 trade asset sale finance urbanization density self_sufficiency marketing"
eststo clear
eststo:reghdfe secondary dd did1 $cv, a(year city_id province_id#i.year) vce(cluster city_id)  
eststo:reghdfe tertiary dd did1 $cv, a(year city_id province_id#i.year) vce(cluster city_id)  

**国家电子商务示范城市试点**
eststo:reghdfe secondary dd edd $cv, a(year city_id province_id#i.year) vce(cluster city_id)  
eststo:reghdfe tertiary dd edd $cv, a(year city_id province_id#i.year) vce(cluster city_id) 

*****首批国家信息消费试点市
eststo:reghdfe secondary dd information_dd $cv, a(year city_id province_id#i.year) vce(cluster city_id)  
eststo:reghdfe tertiary dd information_dd $cv, a(year city_id province_id#i.year) vce(cluster city_id) 
******智慧城市试点
eststo:reghdfe secondary dd intelligent_dd $cv, a(year city_id province_id#i.year) vce(cluster city_id)  
eststo:reghdfe tertiary dd intelligent_dd $cv, a(year city_id province_id#i.year) vce(cluster city_id) 

******2015年的债务管理体制
gen x= 城投债占比 if year==2014
bys city_id:egen x1=min(x)
gen post2015=(year>=2015)
gen debt_2015=post2015*x1
drop x x1
eststo:reghdfe secondary dd debt_2015 $cv, a(year city_id province_id#i.year) vce(cluster city_id)  
eststo:reghdfe tertiary dd debt_2015 $cv, a(year city_id province_id#i.year) vce(cluster city_id) 

******2018年的国地税合并
gen post2018=(year>=2018)
gen merge_2018= self_sufficiency*post2018
eststo:reghdfe secondary dd merge_2018 $cv, a(year city_id province_id#i.year) vce(cluster city_id)  
eststo:reghdfe tertiary dd merge_2018 $cv, a(year city_id province_id#i.year) vce(cluster city_id) 

esttab, replace r2(3) b(%6.3f) se(%6.3f) nogaps compress star(* 0.1 ** 0.05 *** 0.01) scalar(N r2)  keep(dd _cons) indicate( "金税工程=*did1" "国家电子商务示范城市试点=*edd" "首批国家信息消费试点=*information_dd" "智慧城市试点=*intelligent_dd" "控制变量=*sale" "city_fe=*finance" "year_fe=*asset" "province_year_fe=*trade")  noomitted depvar
**************************5.其他稳健性检验***********************
********************************************************************************
*****************************1：排除事后分成调整的影响*****************
use "baseline.dta",clear
global cv "gdp_grow lnpgdp lnpgdp2 trade asset sale finance urbanization density self_sufficiency marketing"
eststo clear
eststo:reghdfe secondary dd $cv if 事后分成调整地区==0,a(year city_id province_id#i.year) vce(cluster city_id)
eststo:reghdfe tertiary  dd $cv if 事后分成调整地区==0,a(year city_id province_id#i.year) vce(cluster city_id)
*****************************2：排除计划单列市的影响*****************
eststo:reghdfe secondary dd $cv if 计划单列市==0,a(year city_id province_id#i.year) vce(cluster city_id) 
eststo:reghdfe tertiary dd $cv if 计划单列市==0,a(year city_id province_id#i.year) vce(cluster city_id)

*********************************3：排除公共卫生突发事件**************
eststo:reghdfe secondary dd $cv if year <2020,a(year city_id province_id#i.year) vce(cluster city_id) 
eststo:reghdfe tertiary dd $cv if year <2020,a(year city_id province_id#i.year) vce(cluster city_id) 

***************************4：被解释变量前置一期**************************************
xtset city_id year
eststo:reghdfe F.secondary dd $cv ,a(year city_id province_id#i.year) vce(cluster city_id )
eststo:reghdfe F.tertiary dd $cv ,a(year city_id province_id#i.year) vce(cluster city_id )

***************************5：变更实证检验模型**************************************
eststo:reghdfe secondary vat_ratio $cv ,a(year city_id province_id#i.year) vce(cluster city_id )
eststo:reghdfe tertiary vat_ratio $cv ,a(year city_id province_id#i.year) vce(cluster city_id )

esttab, replace r2(3) b(%6.3f) se(%6.3f) nogaps compress star(* 0.1 ** 0.05 *** 0.01) scalar(N r2) keep(dd vat_ratio _cons) indicate( "控制变量=*sale" "city_fe=*lnpgdp" "year_fe=*asset" "province_year_fe=*trade") noomitted depvar

***************************6：变更被解释变量**************************************
use "baseline.dta",clear
global cv "gdp_grow lnpgdp lnpgdp2 trade asset sale finance urbanization density self_sufficiency marketing"
sort city_id year
gen 第二产业增加值=secondary*GDP
gen 第三产业增加值=tertiary*GDP
gen x1=l.第二产业增加值
gen x2=l.第三产业增加值
gen x3=l.GDP
gen grow1=(第二产业增加值- x1 )/ x1
gen grow2=(第三产业增加值- x2)/ x2
gen grow3=(第二产业增加值/GDP- x1/x3 )/ (x1/x3)
gen grow4=(第三产业增加值/GDP- x2/x3)/ (x2/x3)
winsor2 grow1 grow2 grow3 grow4,cuts(1 99) replace
drop x1 x2 x3
eststo clear
eststo:reghdfe grow1 dd $cv ,a(year city_id province_id#i.year) vce(cluster city_id )
eststo:reghdfe grow2 dd $cv ,a(year city_id province_id#i.year) vce(cluster city_id )
eststo:reghdfe grow3 dd $cv ,a(year city_id province_id#i.year) vce(cluster city_id )
eststo:reghdfe grow4 dd $cv ,a(year city_id province_id#i.year) vce(cluster city_id )

esttab, replace r2(3) b(%6.3f) se(%6.3f) nogaps compress star(* 0.1 ** 0.05 *** 0.01) scalar(N r2)  keep(dd _cons) noomitted depvar indicate( "控制变量=*sale" "city_fe=*lnpgdp" "year_fe=*asset" "province_year_fe=*trade")

**********************************机制检验分析********************************
******************************************************************************
***已经将回归的数据与地级市的土地出让数据匹配完成
use "baseline.dta",clear
global cv "gdp_grow lnpgdp lnpgdp2 trade asset sale finance urbanization density self_sufficiency marketing"
eststo clear
foreach var in 工业用地 住宅用地 交通运输仓储用地 商服用地 公共管理用地 科教文卫娱用地 其他类型用地{
	eststo:reghdfe `var'出让比例合计 dd $cv ,a(year city_id province_id#i.year) vce(cluster city_id) 
}
esttab, replace r2(3) b(%6.3f) se(%6.3f) nogaps compress star(* 0.1 ** 0.05 *** 0.01) scalar(N r2)  keep(dd _cons) noomitted depvar

***将回归的数据与地级市的财政决算数据匹配完成（财政决算数据只有2015-2021年的数据）
global cv "gdp_grow lnpgdp lnpgdp2 trade asset sale finance urbanization density self_sufficiency marketing"
eststo clear
foreach var in 节能环保支出_e 交通运输支出_e 商业服务业等支出_e 住房保障支出_e {
	eststo:reghdfe `var'_ratio dd $cv ,a(year city_id province_id#i.year) vce(cluster city_id)  
} //回归结果表明，交通运输增长比例显著为正，符合预期。
esttab, replace r2(3) b(%6.3f) se(%6.3f) nogaps compress star(* 0.1 ** 0.05 *** 0.01) scalar(N r2)  keep(dd _cons) noomitted depvar
**********************************异质性分析********************************
**异质性分析结果
use "baseline.dta",clear
gen dd_tax=dd*tax_dep
global cv "gdp_grow lnpgdp lnpgdp2 trade asset sale finance urbanization density self_sufficiency marketing"
eststo clear
eststo:reghdfe secondary dd_tax dd $cv ,a(year city_id province_id#i.year) vce(cluster city_id)
eststo:reghdfe tertiary dd_tax dd $cv ,a(year city_id province_id#i.year) vce(cluster city_id)
 
****人均转移支付的高低
su ptransfer if year==2015,d
local mean_15 = r(mean)
gen byte tmp_mean = (ptransfer <= `mean_15') if year==2015 & ptransfer !=.
egen byte ptr_group  = max(tmp_mean), by(city_id)
drop tmp_mean
bys ptr_group:eststo:reghdfe secondary dd $cv ,a(year city_id province_id#i.year) vce(cluster city_id)
bys ptr_group:eststo:reghdfe tertiary dd $cv ,a(year city_id province_id#i.year) vce(cluster city_id) 

****市场化水平的高低
su marketing if year==2015,d
local mean_15 = r(mean)
gen byte tmp_mean = (marketing >= `mean_15') if year==2015 & marketing !=.
egen byte market_group  = max(tmp_mean), by(city_id)
drop tmp_mean
global x "gdp_grow lnpgdp lnpgdp2 trade asset sale finance urbanization density self_sufficiency"
bys market_group:eststo:reghdfe secondary dd $x ,a(year city_id province_id#i.year) vce(cluster city_id)
bys market_group:eststo:reghdfe tertiary dd $x ,a(year city_id province_id#i.year) vce(cluster city_id) 

esttab, replace r2(3) b(%6.3f) se(%6.3f) nogaps compress star(* 0.1 ** 0.05 *** 0.01) scalar(N r2)  keep(dd_tax dd _cons) noomitted depvar

***************************进一步分析：基于企业进入退出视角考察**************************************
*****************************************************************************************************
use "企业进入退出.dta",clear
merge m:1 city_id year using "baseline.dta" ,nogen keep(1 3)
//egen panelid=group(city_id 行业门类id) //已经生成完毕
global cv "gdp_grow lnpgdp lnpgdp2 trade asset sale finance urbanization density self_sufficiency marketing"
rename ln注册企业对数 ln_entry
gen ln_exist=ln(存续企业数量个)
eststo clear
eststo:reghdfe ln_entry dd  $cv if 产业归类==2 , absorb( city_id#c.行业门类id 行业门类id#c.year  ) vce(cluster panelid )
eststo:reghdfe ln_entry dd  $cv if 行业门类代码 =="B" , absorb( city_id#c.行业门类id 行业门类id#c.year  ) vce(cluster panelid )
eststo:reghdfe ln_entry dd  $cv if 行业门类代码 =="C" , absorb( city_id#c.行业门类id  行业门类id#c.year  ) vce(cluster panelid )
eststo:reghdfe ln_entry dd  $cv if 行业门类代码 =="E" , absorb( city_id#c.行业门类id  行业门类id#c.year  ) vce(cluster panelid )

eststo:reghdfe ln_exist dd $cv if 产业归类==2, absorb( city_id#c.行业门类id  行业门类id#c.year  ) vce(cluster panelid )
eststo:reghdfe ln_exist dd $cv if 行业门类代码 =="B" , absorb(city_id#c.行业门类id  行业门类id#c.year  ) vce(cluster panelid )
eststo:reghdfe ln_exist dd $cv if 行业门类代码 =="C" , absorb(city_id#c.行业门类id  行业门类id#c.year  ) vce(cluster panelid )
eststo:reghdfe ln_exist dd $cv if 行业门类代码 =="E" , absorb( city_id#c.行业门类id  行业门类id#c.year  ) vce(cluster panelid )

esttab, replace r2(3) b(%6.3f) se(%6.3f) nogaps compress star(* 0.1 ** 0.05 *** 0.01) scalar(N r2)  keep(dd ) noomitted depvar indicate( "控制变量=*sale" "city_fe=*lnpgdp" "year_fe=*asset" "province_year_fe=*trade")
